/*
Copyright (c) 1997, 1998 Carnegie Mellon University.  All Rights
Reserved. 

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The WCETT code developed by the CMU/MONARCH group was optimized and tuned by Samir Das and Mahesh Marina, University of Cincinnati. The work was partially done in Sun Microsystems.

*/

#ifndef __wcett_h__
#define __wcett_h__

//#include <agent.h>
//#include <packet.h>
//#include <sys/types.h>
//#include <cmu/list.h>
//#include <scheduler.h>

#include <cmu-trace.h>
#include <priqueue.h>
#include <wcett/wcett_rtable.h>
#include <wcett/wcett_rqueue.h>
#include <wcett/wcett_packet.h>
#include <classifier/classifier-port.h>
#include <mobilenode.h>       //carmen
#include "stdio.h"

#define wcettdebug
#define crcndebug
#define wcettbeta 0.5
/*
  Allows local repair of routes 
*/
#define WCETT_LOCAL_REPAIR

/*
  Allows WCETT to use link-layer (802.11) feedback in determining when
  links are up/down.
*/
//carmen to start hello timer
//#define WCETT_LINK_LAYER_DETECTION

/*
  Causes WCETT to apply a "smoothing" function to the link layer feedback
  that is generated by 802.11.  In essence, it requires that RT_MAX_ERROR
  errors occurs within a window of RT_MAX_ERROR_TIME before the link
  is considered bad.
*/
#define WCETT_USE_LL_METRIC

/*
  Only applies if WCETT_USE_LL_METRIC is defined.
  Causes WCETT to apply omniscient knowledge to the feedback received
  from 802.11.  This may be flawed, because it does not account for
  congestion.
*/
//#define WCETT_USE_GOD_FEEDBACK


class WCETT;

#define MY_ROUTE_TIMEOUT        10                      	// 100 seconds
#define ACTIVE_ROUTE_TIMEOUT    10				// 50 seconds
#define REV_ROUTE_LIFE          6				// 5  seconds
#define BCAST_ID_SAVE           6				// 3 seconds


// No. of times to do network-wide search before timing out for 
// MAX_RREQ_TIMEOUT sec. 
#define RREQ_RETRIES            3  
// timeout after doing network-wide search RREQ_RETRIES times
#define MAX_RREQ_TIMEOUT	10.0 //sec

/* Various constants used for the expanding ring search */
#define TTL_START     5
#define TTL_THRESHOLD 7
#define TTL_INCREMENT 2 

// This should be somewhat related to arp timeout
#define NODE_TRAVERSAL_TIME     0.03             // 30 ms
#define LOCAL_REPAIR_WAIT_TIME  0.15 //sec

// Should be set by the user using best guess (conservative) 
#define NETWORK_DIAMETER        30             // 30 hops

// Must be larger than the time difference between a node propagates a route 
// request and gets the route reply back.

//#define RREP_WAIT_TIME     (3 * NODE_TRAVERSAL_TIME * NETWORK_DIAMETER) // ms
//#define RREP_WAIT_TIME     (2 * REV_ROUTE_LIFE)  // seconds
#define RREP_WAIT_TIME         1.0  // sec

#define ID_NOT_FOUND    0x00
#define ID_FOUND        0x01
//#define INFINITY        0xff

// The followings are used for the forward() function. Controls pacing.
#define DELAY 1.0           // random delay
#define NO_DELAY -1.0       // no delay 

// think it should be 30 ms
#define ARP_DELAY 0.01      // fixed delay to keep arp happy


#define HELLO_INTERVAL          1               // 1000 ms
#define ALLOWED_HELLO_LOSS      3               // packets
#define BAD_LINK_LIFETIME       3               // 3000 ms
#define MaxHelloInterval        (1.25 * HELLO_INTERVAL)
#define MinHelloInterval        (0.75 * HELLO_INTERVAL)

#define MAX_IF 12           //carmen max interface num
#define channeltimer      //for debug carmen
#define neighborno 20;
#define channelno  12;
#define ETTRESCHED 20;

/*
  Timers (Broadcast ID, Hello, Neighbor Cache, Route Cache)
*/
class WCETTBroadcastTimer : public Handler {
public:
        WCETTBroadcastTimer(WCETT* a) : agent(a) {}
        void	handle(Event*);
private:
        WCETT    *agent;
	Event	intr;
};

class WCETTHelloTimer : public Handler {
public:
        WCETTHelloTimer(WCETT* a);
        void	handle(Event*);
        FILE *fp;
private:
        WCETT    *agent;
	Event	intr;
};

class WCETTNeighborTimer : public Handler {
public:
        WCETTNeighborTimer(WCETT* a) : agent(a) {}
        void	handle(Event*);
private:
        WCETT    *agent;
	Event	intr;
};

class WCETTRouteCacheTimer : public Handler {
public:
        WCETTRouteCacheTimer(WCETT* a) : agent(a) {}
        void	handle(Event*);
private:
        WCETT    *agent;
	Event	intr;
};

class WCETTLocalRepairTimer : public Handler {
public:
        WCETTLocalRepairTimer(WCETT* a) : agent(a) {}
        void	handle(Event*);
private:
        WCETT    *agent;
	Event	intr;
};
// carmen

// Timer for channel assignment
//
class WCETTChannelAssignTimer : public TimerHandler {
public:
        WCETTChannelAssignTimer(WCETT* a) :TimerHandler() 
         { 
            a_ = a;

         }

        void expire(Event *e);
protected:
        WCETT *a_;

};

class WCETTHelloCounterTimer : public TimerHandler {
public:
        WCETTHelloCounterTimer(WCETT* a) :TimerHandler() 
         { 
            a_ = a;

         }

        void expire(Event *e);
protected:
        WCETT *a_;

};


/*
  Broadcast ID Cache
*/
class BroadcastID {
        friend class WCETT;
 public:
        BroadcastID(nsaddr_t i, u_int32_t b) { src = i; id = b;  }
 protected:
        LIST_ENTRY(BroadcastID) link;
        nsaddr_t        src;
        u_int32_t       id;
        double          expire;         // now + BCAST_ID_SAVE s
};

LIST_HEAD(wcett_bcache, BroadcastID);


/*
  The Routing Agent
*/
class WCETT: public Agent {

  /*
   * make some friends first 
   */

        friend class wcett_rt_entry;
        friend class WCETTBroadcastTimer;
        friend class WCETTHelloTimer;
        friend class WCETTNeighborTimer;
        friend class WCETTRouteCacheTimer;
        friend class WCETTLocalRepairTimer;
        friend class PacketPr; //carmen
        friend class WCETTChannelAssignTimer;
        friend class WCETTHelloCounterTimer;
        

 public:
        WCETT(nsaddr_t id);

        void		recv(Packet *p, Handler *);

 protected:
        int             command(int, const char *const *);
        int             initialized() { return 1 && target_; }
        //Ramon
        int nIfaces; //total interfaces per node
        NsObject *targetlist[MAX_IF];
        PriQueue *ifqueuelist[MAX_IF];
        

        MobileNode *node_;
        //carmen       
        double  nbchannelRxPr [20][12]; //store the receive Pr at each channel
        int     ChannelETT[20][12];  //first index:neighbor number, second:channel
        int   rtindex;       //index for route entry for the same dst in the route table

        int routetableindex; //index for the final route after source decide which route to go

        /*
         * Route Table Management
         */
        void            rt_resolve(Packet *p);
        void            rt_update(wcett_rt_entry *rt, u_int32_t seqnum,
       		     	  	u_int16_t metric, nsaddr_t nexthop,
		      		double expire_time);
        void            rt_down(wcett_rt_entry *rt);
        void            local_rt_repair(wcett_rt_entry *rt, Packet *p);
 public:
        void            rt_ll_failed(Packet *p);
        void            handle_link_failure(nsaddr_t id);
        //carmen
        void             UpdateIf(wcett_rt_entry *rt,int newif);
        WCETTChannelAssignTimer ChannelAssignTimer_;
        void            ChannelAssign();
        double           ChannelETTCal(wcett_rt_entry *rt);
        void              find_best_rt(Packet *p,int& index);
        int  src_recv_reply; 
    
 protected:
        void            rt_purge(void);

        void            enque(wcett_rt_entry *rt, Packet *p);
        Packet*         deque(wcett_rt_entry *rt);

        /*
         * Neighbor Management
         */
        void            nb_insert(nsaddr_t id);
        WCETT_Neighbor*       nb_lookup(nsaddr_t id);
        void            nb_delete(nsaddr_t id);
        void            nb_purge(void);

        /*
         * Broadcast ID Management
         */

        void            id_insert(nsaddr_t id, u_int32_t bid);
        bool	        id_lookup(nsaddr_t id, u_int32_t bid);
        void            id_purge(void);

        /*
         * Packet TX Routines
         */
        void            forward(wcett_rt_entry *rt, Packet *p, double delay);
        //handleforward is to handle data forward
        void            handleforward(wcett_rt_entry *rt, Packet *p, double delay);
        void            handlereplyforward(Packet *p, double delay);
        void            sendHello(void);
        void            sendRequest(nsaddr_t dst);

        void            sendReply(nsaddr_t ipdst, u_int32_t hop_count,
                                  nsaddr_t rpdst, u_int32_t rpseq,
                                  u_int32_t lifetime, double timestamp, int routeindex,
int rtentryindex); //ETTInfo& routerecord);
        void            sendError(Packet *p, bool jitter = true);
        //carmen
        //Ack is used to measure the channel status
        void            sendAck(void);
                                          
        /*
         * Packet RX Routines
         */
        void            recvWCETT(Packet *p);
        void            recvHello(Packet *p);
        void            recvRequest(Packet *p);
        void            recvReply(Packet *p);
        void            recvError(Packet *p);
        //carmen
        void            recvACK(Packet *p);

	/*
	 * History management
	 */
	
	double 		PerHopTime(wcett_rt_entry *rt);


        nsaddr_t        index;                  // IP Address of this node
        u_int32_t       seqno;                  // Sequence Number
        int             bid;                    // Broadcast ID

        wcett_rtable         rthead;                 // routing table
        wcett_ncache         nbhead;                 // Neighbor Cache
        wcett_bcache          bihead;                 // Broadcast ID Cache

        /*
         * Timers
         */
        WCETTBroadcastTimer  btimer;
        WCETTHelloTimer      htimer;
        WCETTNeighborTimer   ntimer;
        WCETTRouteCacheTimer rtimer;
        WCETTLocalRepairTimer lrtimer;
        WCETTHelloCounterTimer hctimer;    //carmen
        /*
         * Routing Table
         */
        wcett_rtable          rtable;
        /*
         *  A "drop-front" queue used by the routing layer to buffer
         *  packets to which it does not have a route.
         */
        wcett_rqueue         rqueue;

        /*
         * A mechanism for logging the contents of the routing
         * table.
         */
        Trace           *logtarget;

        /*
         * A pointer to the network interface queue that sits
         * between the "classifier" and the "link layer".
         */
        PriQueue        *ifqueue;

        /*
         * Logging stuff
         */
        void            log_link_del(nsaddr_t dst);
        void            log_link_broke(Packet *p);
        void            log_link_kept(nsaddr_t dst);

	/* for passing packets up to agents */
	PortClassifier *dmux_;
        
        //carmen
        int hellocounter; 

};

#endif /* __wcett_h__ */
