/* -*-	Mode:C++; c-basic-offset:8; tab-width:8; indent-tabs-mode:t -*- 
 *
 * Copyright (c) 1997 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: /cvsroot/nsnam/ns-2/common/mobilenode.h,v 1.22 2006/02/21 15:20:18 mahrenho Exp $
 *
 */

/*
 * XXX
 * Eventually energe model and location stuff in this file will be cleaned
 * up and moved to separate file to improve modularity. BUT before that is 
 * finished, they should stay in this file rather than bothering the base 
 * node.
 */

class MobileNode;

#ifndef __ns_mobilenode_h__
#define __ns_mobilenode_h__

#define MN_POSITION_UPDATE_INTERVAL	30.0   // seconds
#define MAX_SPEED			5.0    // meters per second (33.55 mph)
#define MIN_SPEED			0.0
#define ARRAY_SIZE                      30     // define the array size carmen
#define MAX_CHANNELS                    20     //define max channel of a node carmen
 

#include "object.h"
#include "trace.h"
#include "lib/bsd-list.h"
#include "phy.h"
#include "topography.h"
#include "arp.h"
#include "node.h"
#include "gridkeeper.h"
#include "energy-model.h"
#include "location.h"
//carmen
#include "timer-handler.h"
#include "stdio.h"



#if COMMENT_ONLY
		 -----------------------
		|			|
		|	Upper Layers	|
		|			|
		 -----------------------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		|  LL	|	|  LL	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		| Queue	|	| Queue	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		|  Mac	|	|  Mac	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------	 -----------------------
		|	|	|	|	|			|
		| Netif	| <---	| Netif | <---	|	Mobile Node	|
		|	|	|	|	|			|
		 -------	 -------	 -----------------------
		    |		    |
		    |		    |
		 -----------------------
		|			|
		|	Channel(s) 	|
		|			|
		 -----------------------
#endif
class MobileNode;
//carmen
class PacketPr;

struct RecvPr{
     int nodeinfo;
     bool hasElement;
     double Pr;
     double endtime;
     int channelnum; //single channel is default to zero.
     RecvPr *next;
};

struct Strategy{
     int nodeinfo;
     int channel;
     double x;
     double y;
     Strategy *next;

};


//to record some routing infomation
//record how many entry for each dst.
struct DstRtIndex{
     int dst;
     int rt_index;
};

class RtEntryIndex{
     friend class PacketPr;
     friend class MobileNode;
public:
     RtEntryIndex();
     bool add_rt_entry(int dstip);
     int look_rt_index(int dstip);
protected:
     DstRtIndex DstRtIndex_[20];//at most 20 neighbor nodes 

};




class IT_Timer : public TimerHandler {
public:
  IT_Timer(PacketPr *a) : TimerHandler() { a_ = a;}
  void expire(Event *e);
protected:
  PacketPr *a_;
   FILE *fp;
};

class Traffic_Timer : public TimerHandler {
public:
  Traffic_Timer(PacketPr *a) : TimerHandler() { a_ = a;}
  void expire(Event *e);
protected:
  PacketPr *a_;
   FILE *fp;
};


/*
   This class contains some extended functions required by CR simulation

*/

class PacketPr {

public:
     PacketPr();
     PacketPr(MobileNode *parent);

     ~PacketPr();
     

     //get the Rx power from CR PHY
     double getRxPrCRPHY(Packet *p);
    
     
     //delete the unused item in the Prarray
     void deleteExpire();
     
     //store Recv Power and Recv end time info of the current Packet
     //into the Prarray
     //if successful, return 1; otherwise return 0.
     int Store_RxPr_from_PHY(double Pr, Packet *p, int nodeid, int multichan); 
    //record historical interference information
     void IT_Calculate();  
     //obtain the interference information for current node
     double getInterference(int channelno); 
     //calculate the traffic information
     void Traffic_Calculate();
     //calculate the channel utilization information
     void ChanUtil_Calculate();

     //set channel decision associated with current node
     void SetChannelInfo(int channelindex);
     //get channel decision associated with current node
     int  GetChannelInfo();
     void BroadcastChannelInfo(int channelindex);
     //get the current node id;
     int CurrentNodeid(); 
     void SetNicNum(int totalif);

     inline void SetFirstIfIndex(int index) { FirstIfIndex=index; }//set the first if index

     //interface number defined by user
     //at most 20 rt entry(dst) for at each node
     int nicnum; 
     RtEntryIndex RtEntryIndex_;
     int getTrafficCount() {return trafficcount;}
     void increaseTrafficCount() {trafficcount++;}
     void resetTrafficCount(){trafficcount=0; }

     int InsertStrategy(Strategy* info);
     int DecideStrategy();
     int DeleteStrategy(Strategy* info);
     int Searchnode(int node);
     double distance2center();

    //Obtain DSA decision according to different input parameters.
     double getDSAPr(int receivernode);     
     double getDSAPr(int receivernode, int channelindex);

     //timer should be public
     IT_Timer IT_Timer_;
     Traffic_Timer Traffic_Timer_;

     MobileNode *mobilenode_;

protected: 
      RecvPr* RecvPrlist;
      Strategy* Strategy_;
     int ChannelInfo; //channel info from DSA
     int FirstIfIndex; //the index of FirstIf;
     int trafficcount;
     int chanutilcount;
     int lastifindex;
  

     
     int command(int argc, const char* const* argv);
private:
  
     FILE *fp;

    
};



//carmen end

class PositionHandler : public Handler {
public:
	PositionHandler(MobileNode* n) : node(n) {}
	void handle(Event*);
private:
	MobileNode *node;
};

class MobileNode : public Node 
{
	friend class PositionHandler;
public:
	MobileNode();
	virtual int command(int argc, const char*const* argv);

	double	distance(MobileNode*);
	double	propdelay(MobileNode*);
	void	start(void);
        //carmen
        // inline void getLoc(double *x, double *y, double *z) {
	//	update_position();  *x = X_; *y = Y_; *z = Z_;
	//}
        void getLoc(double *x, double *y, double *z);

        inline void getVelo(double *dx, double *dy, double *dz) {
		*dx = dX_ * speed_; *dy = dY_ * speed_; *dz = 0.0;
	}
	inline MobileNode* nextnode() { return link_.le_next; }
	inline int base_stn() { return base_stn_;}
	inline void set_base_stn(int addr) { base_stn_ = addr; }

	void dump(void);

	inline MobileNode*& next() { return next_; }
	inline double X() { return X_; }
	inline double Y() { return Y_; }
	inline double Z() { return Z_; }
	inline double speed() { return speed_; }
	inline double dX() { return dX_; }
	inline double dY() { return dY_; }
	inline double dZ() { return dZ_; }
	inline double destX() { return destX_; }
	inline double destY() { return destY_; }
	inline double radius() { return radius_; }
	inline double getUpdateTime() { return position_update_time_; }
	//inline double last_routingtime() { return last_rt_time_;}

	void update_position();
	void log_energy(int);
	//void logrttime(double);
	virtual void idle_energy_patch(float, float);

        // whether node is single interface multi-channel setting?
        //  carmen
        int IsSingleIfMultiChan() { return SingleIfMultiChan;}
        int IsrecordIfall() {return recordIfall;}

	/* For list-keeper */
        //carmen
	//MobileNode* nextX_;
	//MobileNode* prevX_;
	MobileNode* nextX_[MAX_CHANNELS];
	MobileNode* prevX_[MAX_CHANNELS];
	//carmen
    
        PacketPr PacketPr_;
        int manual; //for debug only
        //record the number of interface for each node
        //it equals to 0 when IfNum is not defined in the script
        int number_of_interface;

        //channel numbers per interface when Channum is defined
       //it equals to 0 when Channum is not defined in the script
        int number_of_channel;
        //channel number with minimum interference
        int channelwithMinIf; 
        Mac* mac_;
        double nodedistance(double x, double y,double z); 
        //C.A.R MEN end

protected:
	/*
	 * Last time the position of this node was updated.
	 */
	double position_update_time_;
        double position_update_interval_;

	/*
         *  The following indicate the (x,y,z) position of the node on
         *  the "terrain" of the simulation.
         */
	double X_;
	double Y_;
	double Z_;
	double speed_;	// meters per second

	/*
         *  The following is a unit vector that specifies the
         *  direction of the mobile node.  It is used to update
         *  position
         */
	double dX_;
	double dY_;
	double dZ_;

        /* where are we going? */
	double destX_;
	double destY_;

	/*
	 * for gridkeeper use only
 	 */
	MobileNode*	next_;
	double          radius_;

	// Used to generate position updates
	PositionHandler pos_handle_;
	Event pos_intr_;

	void	log_movement();
	void	random_direction();
	void	random_speed();
        void    random_destination();
        int	set_destination(double x, double y, double speed);

        //carmen
        //single interface multi-channel
        int SingleIfMultiChan;
        //decide whether to record the interference information at everynode.
        int recordIfall;
       // int currentif_;
	  
private:
	inline int initialized() {
		return (T_ && log_target_ &&
			X_ >= T_->lowerX() && X_ <= T_->upperX() &&
			Y_ >= T_->lowerY() && Y_ <= T_->upperY());
	}
	void		random_position();
	void		bound_position();
	int		random_motion_;	// is mobile

	/*
	 * A global list of mobile nodes
	 */
	LIST_ENTRY(MobileNode) link_;


	/*
	 * The topography over which the mobile node moves.
	 */
	Topography *T_;
	/*
	 * Trace Target
	 */
	Trace* log_target_;
        /* 
	 * base_stn for mobilenodes communicating with wired nodes
         */
	int base_stn_;


	//int last_rt_time_;
};

#endif // ns_mobilenode_h











